#ifndef BLIND_H
#define BLIND_H

#pragma warning(disable:4786)

#include "rpusrdat.h"
#include "rtimport.h"

#include <list>
#include <algorithm>
#include "material.h"
#include "remapper.h"

using namespace std;

void    processBlineDataTemplates();
char    *getBlindDataTemplateName(int templateID);
char    *getBlindDataTemplateNodeName(int templateID);
RwBool  interpVertexCB(void **pUserdataDst, void **pUserdata1, void **pUserdata2, RwReal delta);
RwBool  setVertexCB(void **pUserdata, RpWorldSector *sector, RwInt32 index);
RwBool  setPolygonCB(void **pUserdata, RpWorldSector *sector, RwInt32 index);

struct _blindDataTemplate
{
    int     templateID;
    char    *templateName;
    char    *templateNodeName;
};

typedef struct _blindDataTemplate blindDataTemplate;

typedef list<blindDataTemplate> blindDataTemplateList;
typedef list<blindDataTemplate>::iterator blindDataTemplateIt;

enum blindDataType
{
    invalidBlindDataType = 0,
    vertexBlindDataType,
    faceBlindDataType
};


class blindDataArray
{
public:
    char                *name;
    blindDataType       type;
    RpUserDataFormat    format;

    int                 *intData;
    float               *floatData;
    char                **charData;

    blindDataArray();
    ~blindDataArray();
    bool operator==(const blindDataArray &other) const;
};

typedef list<blindDataArray *> blindDataArrayList;
typedef list<blindDataArray *>::iterator blindDataArrayListIt;

class blindDataSectorRemap
{
public:
    RpWorldSector   *sector;
    int             *vertexMap;
    int             *polygonMap;

    bool operator==(const blindDataSectorRemap &other) const;
};

typedef list<blindDataSectorRemap *> blindDataSectorRemapList;
typedef list<blindDataSectorRemap *>::iterator blindDataSectorRemapListIt;

class blindData
{
public:
    MObject                     object;
    int                         numVerts;
    int                         numPolys;
    blindDataArrayList          list;

    blindData();
    blindData(MObject object);
    ~blindData();
    blindData & operator+=(blindData &b);

    void addMayaBlindData(MFn::Type dataComponent);
    void remap(ReMapper &reMapper);
    void applyMap(blindDataType dataType, int *map, bool invert);
    void addToGeometry(RpGeometry *geometry);

    static RpWorldSector *addToWorldSector(RpWorldSector *worldSector, void *callBackData);
};

#endif /* BLIND_H */